/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IQuests;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.data.ITraderStatus;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.MayorEntity;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.quests.ActionType;
import dev.toma.gunsrpg.common.quests.mayor.ReputationStatus;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.reward.QuestReward;
import dev.toma.gunsrpg.common.skills.BartenderSkill;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_OpenQuestScreen;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.SkillUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2S_QuestActionPacket
extends AbstractNetworkPacket<C2S_QuestActionPacket> {
    private ActionType actionType;
    private int entityId;
    private int questIndex;
    private int[] rewards;

    public C2S_QuestActionPacket() {
    }

    private C2S_QuestActionPacket(ActionType actionType, int entityId) {
        this.actionType = actionType;
        this.entityId = entityId;
    }

    public static C2S_QuestActionPacket makeAssignPacket(MayorEntity entity, Quest<?>[] quests, Quest<?> quest) {
        C2S_QuestActionPacket packet = new C2S_QuestActionPacket(ActionType.ASSIGN, entity.func_145782_y());
        packet.questIndex = ModUtils.indexOf(quests, quest);
        return packet;
    }

    public static C2S_QuestActionPacket makeCancelPacket(MayorEntity entity) {
        return new C2S_QuestActionPacket(ActionType.CANCEL, entity.func_145782_y());
    }

    public static C2S_QuestActionPacket makeCollectionPacket(MayorEntity entity, Integer[] data) {
        C2S_QuestActionPacket packet = new C2S_QuestActionPacket(ActionType.COLLECT, entity.func_145782_y());
        int[] selectedRewards = new int[data.length];
        int i = 0;
        for (Integer integer : data) {
            selectedRewards[i++] = integer;
        }
        packet.rewards = selectedRewards;
        return packet;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.actionType);
        buffer.writeInt(this.entityId);
        switch (this.actionType) {
            case ASSIGN: {
                buffer.writeInt(this.questIndex);
                break;
            }
            case COLLECT: {
                buffer.func_186875_a(this.rewards);
            }
        }
    }

    @Override
    public C2S_QuestActionPacket decode(PacketBuffer buffer) {
        ActionType actionType = (ActionType)buffer.func_179257_a(ActionType.class);
        int entityId = buffer.readInt();
        C2S_QuestActionPacket packet = new C2S_QuestActionPacket(actionType, entityId);
        switch (actionType) {
            case ASSIGN: {
                packet.questIndex = buffer.readInt();
                break;
            }
            case COLLECT: {
                packet.rewards = buffer.func_186863_b();
            }
        }
        return packet;
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        ServerWorld world = player.func_71121_q();
        Entity entity = world.func_73045_a(this.entityId);
        if (entity instanceof MayorEntity) {
            MayorEntity mayor = (MayorEntity)entity;
            PlayerData.get((PlayerEntity)player).ifPresent(playerData -> {
                IQuests questProvider = playerData.getQuests();
                switch (this.actionType) {
                    case ASSIGN: {
                        this.handleQuestAssign(questProvider, player, mayor);
                        break;
                    }
                    case CANCEL: {
                        this.handleQuestCancellation(questProvider, player);
                        break;
                    }
                    case COLLECT: {
                        this.handleQuestRewardCollection((IPlayerData)playerData, player);
                    }
                }
                ITraderStatus status = questProvider.getTraderStandings().getStatusWithTrader(mayor.func_110124_au());
                ReputationStatus reputationStatus = ReputationStatus.getStatus(status.getReputation());
                MayorEntity.ListedQuests quests = mayor.getQuests(player.func_110124_au());
                NetworkManager.sendClientPacket(player, new S2C_OpenQuestScreen(reputationStatus, quests, mayor.func_145782_y(), mayor.getCurrentRefreshTarget()));
            });
        }
    }

    private void handleQuestAssign(IQuests questProvider, ServerPlayerEntity player, MayorEntity mayor) {
        if (questProvider.getActiveQuest().isPresent()) {
            GunsRPG.log.error("Cannot assign over active quest");
            return;
        }
        MayorEntity.ListedQuests listedQuests = mayor.getQuests(player.func_110124_au());
        if (listedQuests != null) {
            Quest<?>[] quests = listedQuests.getQuests();
            if (this.questIndex >= 0 && this.questIndex < quests.length) {
                Quest<?> quest = quests[this.questIndex];
                quest.setStatus(QuestStatus.ACTIVE);
                listedQuests.filterActive();
                quest.assign((PlayerEntity)player);
                questProvider.assignQuest(quest);
            }
        }
    }

    private void handleQuestCancellation(IQuests provider, ServerPlayerEntity player) {
        provider.getActiveQuest().ifPresent(quest -> {
            if (quest.getStatus() != QuestStatus.ACTIVE) {
                GunsRPG.log.error("Cannot cancel inactive quest");
                return;
            }
            quest.onFailed((PlayerEntity)player);
        });
        provider.clearActiveQuest();
    }

    private void handleQuestRewardCollection(IPlayerData data, ServerPlayerEntity player) {
        IQuests provider = data.getQuests();
        ISkillProvider skills = data.getSkillProvider();
        provider.getActiveQuest().ifPresent(quest -> {
            int rewardLimit;
            if (quest.getScheme().isSpecialTaskQuest()) {
                GunsRPG.log.error("Cannot claim rewards from special task quests!");
                return;
            }
            if (quest.getStatus() != QuestStatus.COMPLETED) {
                GunsRPG.log.error("Cannot claim rewards for quest in {} state. Requires COMPLETED state.", (Object)quest.getStatus());
                return;
            }
            BartenderSkill skill = SkillUtil.getTopHierarchySkill(Skills.BARTENDER_I, skills);
            int n = rewardLimit = skill != null ? skill.getRewardCount() : 1;
            if (this.rewards.length > rewardLimit) {
                GunsRPG.log.error("Cannot claim more than {} rewards! {} Tried to pick {} rewards", (Object)rewardLimit, (Object)player.func_200200_C_().getString(), (Object)this.rewards.length);
                return;
            }
            QuestReward reward = quest.getReward();
            if (reward != null) {
                QuestReward.Choice[] choices = reward.getChoices();
                for (int choiceIndex : this.rewards) {
                    if (choiceIndex < 0 || choiceIndex >= choices.length) continue;
                    QuestReward.Choice choice = choices[choiceIndex];
                    choice.distributeToInventory((PlayerEntity)player);
                }
            }
            quest.setStatus(QuestStatus.CLAIMED);
        });
        provider.clearActiveQuest();
    }
}

